%This program runs the simulations behind Fig. 9.

%We run 1,000 experiments for 5 different values of the tick size between
%0.01 and 1.00, which corresponds to Panels A and B. We then repeat the same
%experiments but adjust beta to the tick size such that the expected number of
%experimentations per price stays the same, which corresponds to Panels C
%and D.

%Each experiments has 1.10^6 episodes, with 2 AMMs, \sigma = 5
%\Delta_v = 4. We record all the variables in the last episode.


%%Part 1: Constant beta.

clear
% record running time
% when producing the data the running time was 240 minutes.
tic;

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.  
alpha=0.01;             %alpha  is the learning rate.
beta=0.00008;           %beta   is the exploration decay rate.      
N = 2;                  %N is the number of AMMs.

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l = 5;

% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

%We use 5 values for the tick, and adjust grid_size so that the minimum
%price is 1.00+tick and the maximum is 15-tick.

grid_middle = 8;
vec_tick = [0.01 0.05 0.1 0.5 1];
vec_size = [699 139 69 13 6];

%Simulate for 5 values of tick size:

for iter = 1:5
    %Display Delta_v to follow the execution of the program
    disp(iter)
    %Call the function simulation_rep to run K experiments, adjust
    %tick and grid size.
[last_episodes, ~]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,vec_tick(iter),vec_size(iter),N,K);
%Save the output in the subfolder "Data"
writematrix(last_episodes,sprintf("Data/last_episodes_%d.txt",iter));
end

%%Part 2: Beta adjusted to the tick size.

%Set the beta such that the average number of experimentations per strategy
%is the same as in the baseline case.

%Average number of experimentations in baseline:
base = (exp(-0.00008)/(1-exp(-0.00008)))/139;

vec_beta = zeros(1,5);
for iter=1:5
vec_beta(iter) = log(1+(1/(base*(2*vec_size(iter)+1))));
end

%Simulate for 5 values of tick size:

for iter = 1:5
    %Display Delta_v to follow the execution of the program
    disp(iter)
    %Call the function simulation_rep to run K experiments, adjust beta,
    %tick, grid size.
[last_episodes, ~]=simulation_rep(alpha,vec_beta(iter),T,vh,vl,mu_l,sigma_l,grid_middle,vec_tick(iter),vec_size(iter),N,K);
%Save the output in the subfolder "Data"
writematrix(last_episodes,sprintf("Data/last_episodes_beta_%d.txt",iter));
end

toc
